/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.PHPLibrary;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class LibraryLabelProvider
extends LabelProvider {
    static Image uLibraryImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.editor.php.epl", (String)"/icons/full/obj16/library_obj.gif").createImage();
    private final Map<URL, Image> images;

    public LibraryLabelProvider(Map<URL, Image> images) {
        this.images = images;
    }

    public Image getImage(Object element) {
        PHPLibrary lib;
        URL icon;
        if (element instanceof PHPLibrary && (icon = (lib = (PHPLibrary)element).getIcon()) != null) {
            Image toRet = this.images.get(icon);
            if (toRet != null) {
                return toRet;
            }
            try {
                Image image = new Image((Device)Display.getCurrent(), icon.openStream());
                this.images.put(icon, image);
                return image;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP library label provider - error getting a library image", (Throwable)e);
                return null;
            }
        }
        return uLibraryImage;
    }

    public void dispose() {
        if (this.images != null) {
            for (Image image : this.images.values()) {
                image.dispose();
            }
        }
    }

    public String getText(Object element) {
        IPHPLibrary lib = (IPHPLibrary)element;
        String name = lib.getName();
        return name;
    }
}

